/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.ras;

import com.ibm.ras.RASHandler;
import com.ibm.ras.RASIEvent;
import ibm.nways.ras.LogInterface;
import java.rmi.Naming;
import java.rmi.RemoteException;

public class RemoteHandler
extends RASHandler {
    private LogInterface server;
    private String serverHost = "127.0.0.1";
    private int serverPort = 2099;

    public RemoteHandler() {
        this("", "");
    }

    public RemoteHandler(String string) {
        this(string, "");
    }

    public RemoteHandler(String string, String string2) {
        super(string, string2);
    }

    public void openDevice() {
        String string = this.getRASServer();
        try {
            System.out.println("Looking for RAS Server on host " + string);
            this.server = (LogInterface)Naming.lookup("//" + string + ":" + this.serverPort + "/" + "Log Service");
            System.out.println("RAS Server is " + this.server);
            this.deviceOpen = true;
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    public void writeEvent(RASIEvent rASIEvent) {
        if (!this.deviceOpen) {
            this.openDevice();
        }
        if (this.deviceOpen) {
            rASIEvent.setAttribute("sender", "client");
            try {
                this.server.process(rASIEvent);
                return;
            }
            catch (RemoteException remoteException) {
                this.deviceOpen = false;
                remoteException.printStackTrace();
                return;
            }
        }
    }

    private String getRASServer() {
        return this.serverHost;
    }

    public void setRASServer(String string) {
        this.serverHost = string;
        this.deviceOpen = false;
    }
}

